from causallearn.search.ConstraintBased.PC import pc
from causallearn.utils.GraphUtils import GraphUtils
import pandas as pd

# 假设您的数据已经加载到变量 data 中
data = pd.read_csv('./dataset/exchange_rate/exchange_rate.csv', header=0)
data = data.iloc[:, 1:]
data_array = data.values
# default parameters

cg = pc(data_array)
print(cg.G.graph)

variable_names = data.columns.tolist()
# visualization using pydot
# cg.draw_pydot_graph(labels=variable_names)
cg.draw_pydot_graph()


pyd = GraphUtils.to_pydot(cg.G)
pyd.write_png('PC-exchange.png')

